<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Packedtasks;

/**
 * SearchPackedtasks represents the model behind the search form about `common\models\Packedtasks`.
 */
class SearchPackedtasks extends Packedtasks
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'step', 'status'], 'integer'],
            [['name', 'created_at', 'bot', 'commands'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Packedtasks::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'step' => $this->step,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'bot', $this->bot])
            ->andFilterWhere(['like', 'commands', $this->commands]);

        return $dataProvider;
    }
}
